; magIE.jss
include "hjconst.jsh"
include "hjglobal.jsh"
include "magic.jsh"
include "ie.jsh"

Void Function FocusPointMovedMagEvent (int nX, int nY, int nOldX, int nOldY, int nUnit, int nDir, int nTimeElapsed)
;  This function first tests for the existance of MAGic.  If MAGic is running, it then determines
;  the current window type.  If the current window type is an edit Window, it calls
;  SetMagicFocusArea to set the focus to a region surrounding the cursor position.
Var  Int bSuccess, Int nL, Int nR, Int nT, Int nB, Int nID
; Test for the existance of MAGic.  If MAGic is not running, return without doing any further processing.
If (DidControlChange () == 1) then Return EndIf
Let bSuccess = FALSE
Let nID = GetCurrentControlID ()
If (GetCursorCol () - nX == 1) then Let nX = nX + 1 EndIf
If (GlobalMenuMode == MENU_INACTIVE && GetItemRect (nX, nY, nL, nR, nT, nB, IT_CARET) == FALSE) then
	Let bSuccess = GetObjectRect (nL, nR, nT, nB)
  If (!bSuccess) then Let bSuccess = GetObjectRect (nL, nR, nT, nB)
  If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_BOUNDINGRECT) EndIf
  Else MagSetFocusArea (nX, nY, nOldX, nOldY, nUnit, nDir, nTimeElapsed, TargetItem) EndIf
ElIf (nID == address_bar4 || nID == address_bar3) then
	Let bSuccess = GetItemRect (0, 0, nL, nR, nT, nB, IT_HIGHLIGHT)
	If (bSuccess) then
		MagSetFocusToRect (nL, nR, nT, nB, MTO_CARET)
	Else
		TrackEditWindow (nX, nY, 0, 0, 0, 0, 0, TheTypeCode, GetWindowClass (GetCurrentWindow ()), GetAppMainWindow (GetFocus ()), TargetItem)
	EndIf
Else
  MagSetFocusArea (nX, nY, nOldX, nOldY, nUnit, nDir, nTimeElapsed, TargetItem)
EndIf
Delay (2)
if (GetWindowClass(GetFocus()) == ie3Class) then SaySelectedLink3 () EndIf
Let nSuppressEcho = FALSE
EndFunction

Void Function FocusChangedMagEvent (handle FocusWindow, handle PrevWindow)
;  This function is designed to handle all MAGic specific processing that must occur 
;  when the focus changes.  The window handles of the previous and new windows 
;  are passed to this function to aid in the analysis of the focus change.
; Test for the existance of MAGic.  If MAGic is not running, return without doing any further processing.
Var Int bSuccess, Int nX, Int nY, Int nL, Int nR, Int nT, Int nB, Int nID
If (!MagGetState ()) then Return EndIf
Let bSuccess = FALSE    Let nX = GetCursorCol ()    Let nY = GetCursorRow ()   Let nID = GetCurrentControlID ()
If (GlobalMenuMode == MENU_INACTIVE && GetItemRect (nX ,nY, nL, nR, nT, nB, IT_CARET) == FALSE) then
	Let bSuccess = GetObjectRect (nL, nR, nT, nB)
  If (!bSuccess) then Let bSuccess = GetObjectRect (nL, nR, nT, nB)
  If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_BOUNDINGRECT) EndIf
  Else MagSetFocusArea (nX ,nY, 0, 0, 0, 0, 0, TargetItem) EndIf
ElIf (nID == address_bar4 || nID == address_bar3) then
	Let bSuccess = GetItemRect (0, 0, nL, nR, nT, nB, IT_HIGHLIGHT)
	If (bSuccess) then
		MagSetFocusToRect (nL, nR, nT, nB, MTO_CARET)
	Else
		TrackEditWindow (nX, nY, 0, 0, 0, 0, 0, TheTypeCode, GetWindowClass (GetCurrentWindow ()), GetAppMainWindow (GetFocus ()), TargetItem)
	EndIf
ElIf (MagSetFocusArea (nX, nY, 0, 0, 0, 0, 0, TargetItem) == 0) then
  SetMagicFocus (FocusWindow, PrevWindow)
EndIf
Delay (2)
Let nSuppressEcho = FALSE
EndFunction

